from random import randint
from typing import List

NB_PIOCHE_MAX = 3
NB_JOUEURS = 2
PRENOM_IA = "IA"

def pioche_ordi_dur(nb_allumettes: int) -> int:
  """ Fait piocher l'ordinateur en mode difficile.
  @param nb_allumettes le nombres d'allumettes restantes
  @return le nombre d'allumettes piochées
  precondition: nb_allumettes > 0
  postcondition: la valeur retournée est comprise entre 1 et min(NB_PIOCHE_MAX, nb_allumettes)
  """
  assert nb_allumettes > 0 #précondition

  pioche = (nb_allumettes + NB_PIOCHE_MAX) % (NB_PIOCHE_MAX + 1)
  if pioche == 0:
    pioche = 1
  print(PRENOM_IA + " pioche " + str(pioche) + " allumettes")

  assert pioche >= 1 and pioche <= min(NB_PIOCHE_MAX, nb_allumettes) #postcondition
  return pioche


def pioche_ordi_facile(nb_allumettes: int) -> int:
  """ Fait piocher l'ordinateur en mode facile.
  @param nb_allumettes le nombres d'allumettes restantes
  @return le nombre d'allumettes piochées
  precondition: nb_allumettes > 0
  postcondition: la valeur retournée est comprise entre 1 et min(NB_PIOCHE_MAX, nb_allumettes)
  """
  assert nb_allumettes > 0 #précondition

  pioche = randint(1, min(NB_PIOCHE_MAX, nb_allumettes))
  print(PRENOM_IA + " pioche " + str(pioche) + " allumettes")

  assert pioche >= 1 and pioche <= min(NB_PIOCHE_MAX, nb_allumettes) #postcondition
  return pioche


def pioche_joueur(nb_allumettes: int, prenom: str) -> int:
  """ Fait piocher le joueur.
  @param nb_allumettes le nombres d'allumettes restantes
  @param prenom le prénom du joueur
  @return le nombre d'allumettes piochées
  precondition: nb_allumettes > 0
  postcondition: la valeur retournée est comprise entre 1 et min(NB_PIOCHE_MAX, nb_allumettes)
  """
  assert nb_allumettes > 0 #précondition

  pioche = int(input(prenom + ", il reste " + str(nb_allumettes) + " allumettes, combien tu pioches : "))
  while pioche < 1 or pioche > min(NB_PIOCHE_MAX, nb_allumettes):
    pioche = int(input("Mauvaise pioche, recommence : "))

  assert pioche >= 1 and pioche <= min(NB_PIOCHE_MAX, nb_allumettes) #postcondition
  return pioche


def saisir_joueurs() -> List[str]:
  """ Fait saisir le nom des joueurs.
  @return la liste des joueurs
  postcondition: len(joueurs) <= NB_JOUEURS
  """
  joueurs = []
  prenom = ""
  for i in range(NB_JOUEURS):
    prenom = input("Prénom du joueur " + str(i+1) + " : ")
    if prenom == "":
      prenom = PRENOM_IA
    joueurs.append(prenom)
  assert len(joueurs) == NB_JOUEURS
  return joueurs


if __name__ == "__main__": #point d'entrée du programme
  joueurs = saisir_joueurs()
  if PRENOM_IA in joueurs:
    difficulte = input("Niveau de difficulté [facile|dur] : ")
  qte = randint(12,24)
  jr = randint(0, len(joueurs) - 1) #détermine aléatoirement le joueur qui commence

  while qte > 0:
    if joueurs[jr] == PRENOM_IA:
      pioche = pioche_ordi_dur(qte) if difficulte == "dur" else pioche_ordi_facile(qte)
    else:
      pioche = pioche_joueur(qte, joueurs[jr])
    qte -= pioche
    if qte != 0:
      jr = (jr + 1) % len(joueurs)

  print(joueurs[jr] + " a perdu.")
